import { Block } from "@minecraft/server";
export class Particle {
  static getBoundingBoxFrom(block, accurately = false, offset = 0.25) {
    const minOffset = accurately ? 0 : offset;
    const maxOffset = accurately ? 1 : 1 + offset;
    return {
      minX: block.location.x - minOffset,
      minY: block.location.y - minOffset,
      minZ: block.location.z - minOffset,
      maxX: block.location.x + maxOffset,
      maxY: block.location.y + maxOffset,
      maxZ: block.location.z + maxOffset,
    }
  }
  static getRandomPositionInsideBoundingBox(boundingBox) {
    return {
      x: Math.random() * (boundingBox.maxX - boundingBox.minX) + boundingBox.minX,
      y: Math.random() * (boundingBox.maxY - boundingBox.minY) + boundingBox.minY,
      z: Math.random() * (boundingBox.maxZ - boundingBox.minZ) + boundingBox.minZ
    }
  }
}